/****** Object:  StoredProcedure [dbo].[P_EST_PROD_EST_TRIB_CONF_GRP_LOTE_APLICAR]    Script Date: 05/08/2014 09:17:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_EST_TRIB_CONF_GRP_LOTE_APLICAR]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_EST_TRIB_CONF_GRP_LOTE_APLICAR]
GO
/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: Insert em EST_PROD_EST_TRIB_CONF_GRP
'Tabelas.............: 
'Dt Modificação......: 12/05/2021
'Modificação.........: Tag #A001 Ajuste no ALIAS da tabela 
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/
CREATE PROCEDURE [dbo].[P_EST_PROD_EST_TRIB_CONF_GRP_LOTE_APLICAR](@FLAG_CONSULTAR	INT, 
																		@FLAG_REFAZ INT,	
																		@SQL_FILTRO NVARCHAR(MAX), 
																		@CD_CTR		NVARCHAR(500) = '')
AS
BEGIN
   SET NOCOUNT ON
   
   DECLARE @SQL_EXEC NVARCHAR(MAX)
   CREATE TABLE  #TBL_EST_PROD_TRIB_GRP (CD_EMP            INT,
										 CD_PROD           INT,
										 CD_CTR            INT,
										 DS_PROD           VARCHAR(200),
										 NR_NCM            VARCHAR(50),
										 LISTA_PROD        INT,
										 LISTA_PROD_NAME   VARCHAR(50))


	 SET @SQL_EXEC = N'INSERT INTO #TBL_EST_PROD_TRIB_GRP 
								SELECT 
									  DISTINCT EST_PROD.CD_EMP, EST_PROD.CD_PROD, 
									  EST_TRIB_CONF_GRP.CD_CTR AS CD_CTR , 
												  EST_PROD.DS_PROD, EST_PROD.NR_NCM, EST_PROD.LISTA_PROD,
												  CASE WHEN EST_PROD.LISTA_PROD = 0 THEN  
															   ''POSITIVA''
														WHEN EST_PROD.LISTA_PROD = 1 THEN  
															   ''NEGATIVA''
												   WHEN EST_PROD.LISTA_PROD = 2 THEN  
															   ''NEUTRA''
														ELSE
														''NAO USA LISTA''
												  END AS LISTA_PROD_NAME                                                 
								FROM EST_PROD    
									 INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON 
											  EST_PROD.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
											  EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD
									  
									 INNER JOIN EST_TRIB_CONF_GRP_NCM ON 
											  EST_TRIB_CONF_GRP_NCM.NR_NCM  COLLATE SQL_Latin1_General_CP1_CI_AS       = DBO.F_LIMPA_ZERO_ESQUERDA(EST_PROD.NR_NCM) COLLATE SQL_Latin1_General_CP1_CI_AS
								   
									 INNER JOIN EST_TRIB_CONF_GRP ON 
											  EST_TRIB_CONF_GRP_NCM.CD_EMP        = EST_TRIB_CONF_GRP.CD_EMP AND 
											  EST_TRIB_CONF_GRP_NCM.CD_CTR        = EST_TRIB_CONF_GRP.CD_CTR                                              
											  AND EST_TRIB_CONF_GRP.TP_LISTA      = EST_PROD.LISTA_PROD  
											  
									 INNER JOIN EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL CLASS_FISC_REGIAO ON 
											  EST_TRIB_CONF_GRP.CD_EMP            = CLASS_FISC_REGIAO.CD_EMP        AND
											  EST_TRIB_CONF_GRP.CD_REGIAO_FISCAL  = CLASS_FISC_REGIAO.CD_REGIAO_FISCAL AND 
											  EST_TRIB_CONF_GRP.CD_CLASS_FISC     = CLASS_FISC_REGIAO.CD_CLASS_FISC  AND
											  EST_PROD.CD_PROD                    = CLASS_FISC_REGIAO.CD_PROD
													
								WHERE ' + @SQL_FILTRO

		EXEC (@SQL_EXEC)

        SET @SQL_EXEC = N'INSERT INTO #TBL_EST_PROD_TRIB_GRP 
                                    SELECT 
                                          DISTINCT EST_PROD.CD_EMP, EST_PROD.CD_PROD, 
                                          EST_TRIB_CONF_GRP.CD_CTR AS CD_CTR , 
                                                      EST_PROD.DS_PROD, EST_PROD.NR_NCM, EST_PROD.LISTA_PROD,
                                                      CASE WHEN EST_PROD.LISTA_PROD = 0 THEN  
                                                                   ''POSITIVA''
                                                            WHEN EST_PROD.LISTA_PROD = 1 THEN  
                                                                   ''NEGATIVA''
                                                       WHEN EST_PROD.LISTA_PROD = 2 THEN  
                                                                   ''NEUTRA''
                                                            ELSE
                                                            ''NAO USA LISTA''
                                                      END AS LISTA_PROD_NAME                                                 
                                    FROM EST_PROD    
                                         INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON 
                                                  EST_PROD.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
                                                  EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD
                                          
                                         INNER JOIN EST_TRIB_CONF_GRP_NCM ON 
                                                  EST_TRIB_CONF_GRP_NCM.NR_NCM  COLLATE SQL_Latin1_General_CP1_CI_AS       = EST_PROD.NR_NCM COLLATE SQL_Latin1_General_CP1_CI_AS 
                                        INNER JOIN EST_TRIB_CONF_GRP ON EST_TRIB_CONF_GRP_NCM.CD_EMP        = EST_TRIB_CONF_GRP.CD_EMP 
																			  AND EST_TRIB_CONF_GRP_NCM.CD_CTR        = EST_TRIB_CONF_GRP.CD_CTR                                              
																			  AND EST_TRIB_CONF_GRP.TP_LISTA      = EST_PROD.LISTA_PROD
																			  AND EST_TRIB_CONF_GRP.CD_CLASS_FISC = EST_PROD.CD_CLASS_FISC
										LEFT OUTER JOIN #TBL_EST_PROD_TRIB_GRP TEMP ON EST_PROD.CD_EMP = TEMP.CD_EMP
																					   AND EST_PROD.CD_PROD = TEMP.CD_PROD
										LEFT OUTER JOIN EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL CLASS_FISC_REGIAO ON 
																										  EST_TRIB_CONF_GRP.CD_EMP   = CLASS_FISC_REGIAO.CD_EMP  AND
																										  EST_PROD.CD_PROD           = CLASS_FISC_REGIAO.CD_PROD   
                                  WHERE TEMP.CD_EMP IS NULL AND CLASS_FISC_REGIAO.CD_EMP IS NULL AND ' + @SQL_FILTRO

		EXEC (@SQL_EXEC)
-------------------------------------------------------------------------------------------------------       
		IF @FLAG_CONSULTAR = 1
		BEGIN
			SELECT DISTINCT 
					CD_EMP, 
					CD_PROD, 
					DS_PROD, 
					NR_NCM, 
					LISTA_PROD, 
					LISTA_PROD_NAME 
			FROM #TBL_EST_PROD_TRIB_GRP
			RETURN;
		END

		IF @FLAG_REFAZ = 1
		BEGIN
			IF @CD_CTR <> '' 
			BEGIN
				DELETE A 
				FROM 
					EST_PROD_EST_TRIB_CONF_GRP A
				WHERE A.CD_CTR  IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_CTR))
			END 
		END 
-------------------------------------------------------------------------------------------------------
		--DELETE FROM EST_PROD_EST_TRIB_CONF_GRP
		--WHERE EXISTS (SELECT T.CD_EMP 
		--					FROM #TBL_EST_PROD_TRIB_GRP T
		--					WHERE T.CD_EMP           = EST_PROD_EST_TRIB_CONF_GRP.CD_EMP
		--								AND T.CD_PROD = EST_PROD_EST_TRIB_CONF_GRP.CD_PROD
		--								AND T.CD_CTR = EST_PROD_EST_TRIB_CONF_GRP.CD_CTR)  

-- Tag #A001
		INSERT INTO EST_PROD_EST_TRIB_CONF_GRP(CD_EMP,  CD_PROD,  CD_CTR)
		SELECT DISTINCT 
              T.CD_EMP, 
              T.CD_PROD, 
              T.CD_CTR
		FROM 
			#TBL_EST_PROD_TRIB_GRP T
			LEFT JOIN EST_PROD_EST_TRIB_CONF_GRP GRP_PROD ON
				T.CD_EMP	= GRP_PROD.CD_EMP AND 
				T.CD_PROD	= GRP_PROD.CD_PROD AND 
				T.CD_CTR	= GRP_PROD.CD_CTR
		WHERE
			GRP_PROD.CD_EMP IS NULL;


-------------------------------------------------------------------------------------------------------
END
